/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.compiler;

public class Variable {
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int CONST_STRING = 4;
    public static final int CONST_INTEGER = 5;
    public static final int CONST_FLOAT = 6;
    private String name;
    private String value;
    private int type;

    public Variable(String name, int type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isTypeString() {
        return this.type == 1;
    }

    public boolean isTypeInteger() {
        return this.type == 2;
    }

    public boolean isTypeFloat() {
        return this.type == 3;
    }

    public boolean isVariableType() {
        return this.isTypeFloat() || this.isTypeInteger() || this.isTypeString();
    }

    public boolean isNumber() {
        return this.isConstantFloat() || this.isConstantInteger() || this.isTypeFloat() || this.isTypeInteger();
    }

    public boolean isConstantString() {
        return this.type == 4;
    }

    public boolean isConstantInteger() {
        return this.type == 5;
    }

    public boolean isConstantFloat() {
        return this.type == 6;
    }

    public boolean isConstant() {
        return this.isConstantString() || this.isConstantInteger() || this.isConstantFloat();
    }

    public String getValue() {
        return this.value;
    }
}

